﻿//////////////////////////////////////////////
// ContentLoader.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkExport
{
	class Exportable ;
	class Node ;
}

namespace nkWinUi
{
	class Component ;
	class Layout ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

// nkExport
#include <NilkinsExport/Exporter/ExporterLoadResult.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

// Standards
#include <string_view>

/// Class ------------------------------------

namespace nkWinUi
{	
	class DLL_WINUI_EXPORT ContentLoader final
	{		
		public :

			// Fonctions pratiques
			static nkExport::ExporterLoadResult inputData (nkMemory::StringView filePath) ;
			static nkExport::ExporterLoadResult inputDataSources (nkMemory::StringView sources) ;
			static bool outputData (nkMemory::StringView content, nkMemory::StringView path) ;

			// Save
			static bool saveObjectDeclaration (nkExport::Exportable* object, nkMemory::StringView pathFromData) ;

			// Load
			// Component solitaire
			static Component* loadComponentDeclaration (nkMemory::StringView pathFromData) ;
			static Component* processComponentSources (nkMemory::StringView sources) ;
			static Component* processComponentTree (nkExport::Node* tree) ;
			// Layout solitaire
			static Layout* loadLayoutDeclaration (nkMemory::StringView pathFromData) ;
			static Layout* processLayoutSources (nkMemory::StringView sources) ;
			static Layout* processLayoutTree (nkExport::Node* tree) ;
			// Interface mixant les deux
			static Component* loadInterfaceDeclaration (nkMemory::StringView pathFromData) ;
			static Component* processInterfaceSources (nkMemory::StringView sources) ;
			static Component* processInterfaceTree (nkExport::Node* tree) ;

		private :
		
			// Constructor, destructor
			ContentLoader() = delete ;
			~ContentLoader() = delete ;
	} ;
}